#!/bin/sh
# exit in case of error
set -e

initCli() {
	echo "Start Cli init"
	# create default fields in conf file
	echo "Init conf file"
	3dJuumpInfiniteCli cli conf init --location systemscope
	if [ $? -ne 0 ]
	then
		exit 1
	fi
	# validate conf file and encrypt sensitive values
	echo "Consolidate conf file"
	3dJuumpInfiniteCli cli conf consolidate --location systemscope
	if [ $? -ne 0 ]
	then
		exit 1
	fi
	echo "Cli init done"
}

runAsyncJobSolver() {
	echo "Start AsyncJobSolver"
	# use exec so we will receive signals
	exec 3dJuumpInfiniteCli asyncjob solver thedirectory /tmp --maxcpu $ASYNCJOB_SOLVER_MAX_CPU --maxmemorymb $ASYNCJOB_SOLVER_MAX_MEMORY_MB
}

conf_file="/etc/3djuump-infinite-cli/conf_4_1.json"
echo "Conf file location : $conf_file"

# start final executable
case $CONTAINER_ROLE in
	"init")
		initCli $conf_file
		;;
	"asyncjobsolver")
		runAsyncJobSolver $conf_file
		;;
	"sleep")
		echo "Time to sleep zzzz ..."
		# use exec so we will receive signals
		exec sleep 500000000000000000000000000000000000000
		;;
	*)
		echo "CONTAINER_ROLE env should set to a correct value !"
		exit 1
esac

